package gov.va.med.mhv.sm.admin.data.enums;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
public enum SMErrorEnum implements Serializable {
	

	UNKNOWN_EXCEPTION ("Unexpected Error Occurred"),
	TRIAGE_GROUP_NOT_FOUND ("Triage Group is not found"),
	ACTIVE_TRIAGE_GROUP_NOT_FOUND ("Active Triage Group is not found."),
	TRIAGE_GROUP_NOT_FOUND_FOR_STATION ("Triage Groups for station are not found."),
	PCMM_PROVIDERS_NOT_FOUND ("PCMM Providers are not found."),
	INVALID_HTTP_REQUEST ("Bad HTTP request"),
	CLINICS_NOT_FOUND ("No clinics found matching query string."),
	CPRS_TIT_TILES_NOT_FOUND("No clinics found matching query string."),
	CLINICIANS_NOT_FOUND("Clinicians not found matching query string.");
	
	

	private String errorMessage;
	private Class<?> clazz;
	
	private SMErrorEnum() {
	}
	
	private SMErrorEnum(String errorMessage){
		this.errorMessage = errorMessage;
		this.clazz = null;
	}
	
	public String getErrorMessage() {
		return errorMessage;
	}
	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}
	public Class<?> getClazz() {
		return clazz;
	}
	public void setClazz(Class<?> clazz) {
		this.clazz = clazz;
	}
	
	public static List<SMErrorEnum> toList(){
		return Arrays.asList(SMErrorEnum.values());
	}
	
}
